<?php
/**
 * DASHBOARD REFORÇADO - WEB PLAYER (BLINDAGEM TOTAL V6)
 */

// 1. Configurações de Persistência (Impede que o navegador apague a sessão ao fechar)
$lifetime = 60 * 60 * 24 * 30; // 30 Dias em segundos
ini_set('session.gc_maxlifetime', $lifetime);
ini_set('session.cookie_lifetime', $lifetime);
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);

// 2. Nome de Sessão Exclusivo (Evita conflitos com outros apps no mesmo servidor)
session_name('WP_SECURE_AUTH_SESS');

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 3. Blindagem contra Regeneração Agressiva
// Só regenera o ID se a sessão for nova ou tiver mais de 1 hora, evitando perda de conexão
if (!isset($_SESSION['initiated'])) {
    session_regenerate_id(true);
    $_SESSION['initiated'] = time();
} elseif (time() - $_SESSION['initiated'] > 3600) {
    session_regenerate_id(true);
    $_SESSION['initiated'] = time();
}

// 5. Impedir Cache (Segurança para não exibir dados após logout)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

include 'config.php';

// Caminho para o sistema de DNS
$json_file = './includes/dns/dns.json'; 
$servidoresEmUso = 0;

if (file_exists($json_file)) {
    $json_content = @file_get_contents($json_file);
    $servers = json_decode($json_content, true);
    
    if (is_array($servers)) {
        foreach($servers as $key => $val) {
            if (strpos($key, '_name') !== false && !empty($val)) {
                $servidoresEmUso++;
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Admin</title>
    
    <style>
        html { background-color: #f9fafb; } 
        html.dark { background-color: #030712; } 
        body { visibility: hidden; } 
        body.theme-ready { visibility: visible; }
    </style>

    <script src="https://cdn.tailwindcss.com"></script>
    
    <script>
        (function() {
            const theme = localStorage.getItem('theme');
            const systemDark = window.matchMedia('(prefers-color-scheme: dark)').matches;
            if (theme === 'dark' || (!theme && systemDark)) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        })();

        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        pearl: '#FBFCF8',
                        darkBg: '#030712'
                    }
                }
            }
        }
    </script>
</head>

<body class="bg-gray-50 dark:bg-darkBg text-gray-900 dark:text-gray-100 transition-colors duration-300 antialiased">

    <header class="w-full h-16 bg-white/80 dark:bg-gray-900/80 backdrop-blur-md shadow-sm flex items-center justify-between px-6 sticky top-0 z-50 border-b border-gray-200 dark:border-gray-800">
        <div class="flex items-center gap-4">
            <button id="menuToggle" class="p-2 rounded-lg md:hidden hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">
                <span class="text-xl">☰</span>
            </button>
            <div class="text-xl font-extrabold bg-gradient-to-r from-blue-600 to-cyan-500 bg-clip-text text-transparent">
                INICIO
            </div>
        </div>

        <div class="flex items-center gap-3">
            <button id="toggleDark" class="w-10 h-10 flex items-center justify-center bg-gray-100 dark:bg-gray-800 rounded-full hover:ring-2 ring-blue-500 transition-all">
                <span class="dark:hidden">🌙</span>
                <span class="hidden dark:inline">☀️</span>
            </button>
            <div class="h-8 w-[1px] bg-gray-200 dark:bg-gray-700 mx-2 hidden sm:block"></div>
            <div class="hidden sm:flex flex-col items-end">
                <span class="text-xs text-gray-500 dark:text-gray-400">Logado como</span>
                <span class="text-sm font-semibold text-blue-600 dark:text-blue-400">@<?php echo htmlspecialchars($_SESSION["username"]); ?></span>
            </div>
        </div>
    </header>

    <div class="flex">
        <aside id="sidebar" class="w-64 bg-white dark:bg-gray-900 h-[calc(100vh-4rem)] border-r border-gray-200 dark:border-gray-800 fixed md:sticky top-16 left-0 transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out z-40">
            <nav class="flex flex-col p-4 gap-2">
                <a href="dashboard.php" class="flex items-center gap-3 p-3 rounded-xl bg-blue-600 text-white shadow-blue-500/20 shadow-lg">
                    <span>🏠</span> <span class="font-medium">Dashboard</span>
                </a>
                <a href="servidores.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all group">
                    <span class="group-hover:scale-110 transition-transform">🖥️</span> <span class="text-gray-600 dark:text-gray-300">Servidores</span>
                </a>
                <a href="admin.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all group">
                    <span class="group-hover:scale-110 transition-transform">👤</span> <span class="text-gray-600 dark:text-gray-300">Admin</span>
                </a>
                <div class="my-4 border-t border-gray-100 dark:border-gray-800"></div>
                <a href="logoutvs.php" class="flex items-center gap-3 p-3 rounded-xl text-red-500 hover:bg-red-50 dark:hover:bg-red-900/20 transition-all">
                    <span>🚪</span> <span class="font-medium">Sair</span>
                </a>
            </nav>
        </aside>

        <main class="flex-1 p-4 md:p-8 w-full max-w-7xl mx-auto"> 
            <div class="mb-8">
                <h2 class="text-3xl font-bold text-gray-800 dark:text-white">Painel de Controle</h2>
                <p class="text-gray-500 dark:text-gray-400">Bem-vindo ao centro de comando do seu Web Player.</p>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
                <a href="servidores.php" class="group bg-white dark:bg-gray-900 p-1 rounded-3xl border border-gray-200 dark:border-gray-800 shadow-sm hover:shadow-xl transition-all duration-300">
                    <div class="bg-blue-600 rounded-[22px] p-6 text-white h-full">
                        <div class="flex justify-between items-start mb-4">
                            <span class="text-4xl bg-white/20 p-3 rounded-2xl">🖥️</span>
                            <span class="bg-white/20 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-widest">Ativos</span>
                        </div>
                        <h3 class="text-xl font-bold mb-1">Servidores</h3>
                        <p class="text-blue-100 text-3xl font-black"><?php echo (int)$servidoresEmUso; ?></p>
                    </div>
                </a>

                <a href="login.php" class="group bg-white dark:bg-gray-900 p-1 rounded-3xl border border-gray-200 dark:border-gray-800 shadow-sm hover:shadow-xl transition-all duration-300">
                    <div class="bg-emerald-600 rounded-[22px] p-6 text-white h-full">
                        <div class="flex justify-between items-start mb-4">
                            <span class="text-4xl bg-white/20 p-3 rounded-2xl">▶️</span>
                            <span class="bg-white/20 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-widest">Online</span>
                        </div>
                        <h3 class="text-xl font-bold mb-1">Web Player</h3>
                        <p class="text-emerald-100 text-sm opacity-80">Acesse a interface de streaming agora.</p>
                    </div>
                </a>

                <a href="admin.php" class="group bg-white dark:bg-gray-900 p-1 rounded-3xl border border-gray-200 dark:border-gray-800 shadow-sm hover:shadow-xl transition-all duration-300">
                    <div class="bg-amber-500 rounded-[22px] p-6 text-white h-full">
                        <div class="flex justify-between items-start mb-4">
                            <span class="text-4xl bg-white/20 p-3 rounded-2xl">⚙️</span>
                            <span class="bg-white/20 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-widest">Sistema</span>
                        </div>
                        <h3 class="text-xl font-bold mb-1">Configurações</h3>
                        <p class="text-amber-100 text-sm opacity-80">Gerenciar administradores e permissões.</p>
                    </div>
                </a>
            </div>

            <footer class="mt-12 text-center text-gray-400 dark:text-gray-600 text-xs">
                © 2026 Web Player - Todos os direitos reservados.
            </footer>
        </main>
    </div>

    <div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-30 hidden backdrop-blur-sm"></div>

    <script>
        document.body.classList.add('theme-ready');
        const toggleDark = document.getElementById('toggleDark');
        const html = document.documentElement;
        const menuToggle = document.getElementById('menuToggle');
        const sidebar = document.getElementById('sidebar');
        const overlay = document.getElementById('sidebarOverlay');

        toggleDark.addEventListener('click', () => {
            const isDark = html.classList.toggle('dark');
            localStorage.setItem('theme', isDark ? 'dark' : 'light');
        });

        const toggleSidebar = () => {
            sidebar.classList.toggle('-translate-x-full');
            overlay.classList.toggle('hidden');
        };

        menuToggle.addEventListener('click', toggleSidebar);
        overlay.addEventListener('click', toggleSidebar);
    </script>
</body>
</html>